local t = Def.ActorFrame{}
local pn = ... ;
local timercountdown = ... ;
local tContainer = ... ;
local TimerType = LoadFile("TimerType.cfg","Settings")

local function TimerCountDownUpdate(self)
	local TopScreen = SCREENMAN:GetTopScreen()
	local ScreenName = TopScreen:GetName()
	tContainer = timercountdown
	local time = math.floor((-self:GetSecsIntoEffect() + tContainer))

	if ScreenName == "ScreenSelectMusic" then
		if time == 0 and STATSMAN:GetStagesPlayed() > 0 then
			SCREENMAN:GetTopScreen():SetNextScreenName("ScreenEvaluationSummary") SCREENMAN:GetTopScreen():StartTransitioningScreen("SM_GoToNextScreen")
		elseif time == 0 then
			SCREENMAN:GetTopScreen():SetNextScreenName("ScreenGameOver") SCREENMAN:GetTopScreen():StartTransitioningScreen("SM_GoToNextScreen")
		end
	end
	
	-- ScreenModPanel screens.
	if string.match(ScreenName,"ModPanel") then
		if time == 0 then SCREENMAN:GetTopScreen():StartTransitioningScreen("SM_GoToNextScreen") end
	elseif ScreenName == "ScreenThemeColorPanel" then
		if time == 0 then SCREENMAN:GetTopScreen():StartTransitioningScreen("SM_GoToNextScreen") end
	end

	if ScreenName == "ScreenEvaluationNormal" then
		-- If the Timer has reached 00:09 or lower, it will reset the Timer to 00:05 to give a little time to check Screen.
		if time == 0 then
			SCREENMAN:GetTopScreen():SetNextScreenName("ScreenEvaluationSummary") SCREENMAN:GetTopScreen():StartTransitioningScreen("SM_GoToNextScreen")
		end
	end
	
	if ScreenName == "ScreenEvaluationSummary" then
		-- If the Timer has reached 00:09 or lower, it will reset the Timer to 00:05 to give a little time to check Screen.
		if time == 0 then
			SCREENMAN:GetTopScreen():SetNextScreenName("ScreenGameOver") SCREENMAN:GetTopScreen():StartTransitioningScreen("SM_GoToNextScreen")
		end
	end
	
	if ScreenName == "ScreenViewScores" then
		if time == 0 then
			SCREENMAN:GetTopScreen():StartTransitioningScreen("SM_GoToNextScreen")
		end
	end
	
	if time > 7250 then
		time = math.floor((-self:GetSecsIntoEffect() + math.huge)) -- (math.huge = Infinite)
		timer_text:settext("99:99")
		MetroQuad.Global.MiscOptions.TimerCountDownContainer = time
		timer_infinite_text:visible(false)
	elseif time <= -1 then
		time = 0 -- This works as Force Stop when Timer reach 00:00 to prevent negative Timer.
		timer_text:settext(SecondsToMMSS(time))
		timer_infinite_text:visible(false)
	else
		time = math.floor((-self:GetSecsIntoEffect() + tContainer))
		timer_text:settext(SecondsToMMSS(time))
		MetroQuad.Global.MiscOptions.TimerCountDownContainer = time
		timer_infinite_text:visible(false)
	end
end

local function TimerNormalUpdate(self)
	local TopScreen = SCREENMAN:GetTopScreen()
	local ScreenName = TopScreen:GetName()
	local time = math.floor((-self:GetSecsIntoEffect() + MetroQuad.Global.MiscOptions.TimerNormalStart))

	if ScreenName == "ScreenTitleJoin" then
		time = math.floor((-self:GetSecsIntoEffect() + 30)) -- Forced Custom Time on this screen.
		timer_text:visible(false)
		if time == 0 then
			SCREENMAN:GetTopScreen():StartTransitioningScreen("SM_GoToNextScreen")
		end
	end
	
	if ScreenName == "ScreenSelectProfile" then
		if time == 0 then SCREENMAN:GetTopScreen():StartTransitioningScreen("SM_GoToNextScreen") end
	end
	
	if ScreenName == "ScreenSelectStyle" then
		if time == 0 then -- If Time get 00 here, you have to tell what Style, PlayMode and NextScreen must be set.
			GAMESTATE:SetCurrentStyle("Single")
			GAMESTATE:SetCurrentPlayMode(0)
			SCREENMAN:GetTopScreen():SetNextScreenName("ScreenSelectMusic") SCREENMAN:GetTopScreen():StartTransitioningScreen("SM_GoToNextScreen")
		end
	end
	
	if ScreenName == "ScreenSelectMusic" then
		if time == 0 and GetCurrentSong() == nil then -- If Timer reachs 0 and Players aren't on a Song, Select a Random Song.
			local RandomSong = SONGMAN:GetRandomSong()
			local MusicWheel = SCREENMAN:GetTopScreen():GetMusicWheel()
			MusicWheel:SelectSong(RandomSong)
			MusicWheel:Move(1); -- lazy fix to trigger CurrentSongChanged
			MusicWheel:Move(-1); -- lazy fix to trigger CurrentSongChanged
			MusicWheel:Move(0); -- lazy fix to trigger CurrentSongChanged
		elseif time == 0 then
			SCREENMAN:GetTopScreen():StartTransitioningScreen("SM_GoToNextScreen")
		end
	end
	
	-- ScreenModPanel screens.
	if string.match(ScreenName,"ModPanel") then
		if time == 0 then SCREENMAN:GetTopScreen():StartTransitioningScreen("SM_GoToNextScreen") end
	elseif ScreenName == "ScreenThemeColorPanel" then
		if time == 0 then SCREENMAN:GetTopScreen():StartTransitioningScreen("SM_GoToNextScreen") end
	end
	
	if ScreenName == "ScreenEvaluationNormal" then
		-- If the Timer has reached 00:09 or lower, it will reset the Timer to 00:05 to give a little time to check Screen.
		if time == 0 then
			SCREENMAN:GetTopScreen():StartTransitioningScreen("SM_GoToNextScreen")
		end
	end
	
	if ScreenName == "ScreenEvaluationSummary" then
		-- If the Timer has reached 00:09 or lower, it will reset the Timer to 00:05 to give a little time to check Screen.
		if time == 0 then
			SCREENMAN:GetTopScreen():StartTransitioningScreen("SM_GoToNextScreen")
		end
	end
	
	if ScreenName == "ScreenViewScores" then
		if time == 0 then
			SCREENMAN:GetTopScreen():StartTransitioningScreen("SM_GoToNextScreen")
		end
	end
	
	if time > 250 then
		time = math.floor((-self:GetSecsIntoEffect() + math.huge)) -- (math.huge = Infinite)
		timer_text:settext("") -- (We hide the text to let the Infinite symbol be shown).
		timer_infinite_text:visible(true) -- (It should be visible only when Infinite is set on Options)
		timer_infinite_text:diffuse(Black())
	elseif time <= -1 then
		time = 0 -- This works as Force Stop when Timer reach 00:00 to prevent negative Timer.
		timer_text:settextf("%02.f",time)
		timer_infinite_text:visible(false)
	else
		timer_text:settextf("%02.f",time)
		timer_infinite_text:visible(false)
	end
end

local function IsCountDownOn()
	if TimerType == "Countdown" then return true end
	if TimerType == "Timer" then return false end
end

t[#t+1] = Def.ActorFrame{
	Name="Timer";
	InitCommand=function(self)
		timer_text = self:GetChild("timer_text")
		timer_infinite_text = self:GetChild("timer_infinite_text")
		self:effectperiod(2^16)
		
		if GAMESTATE:IsEventMode() == false then -- The Timer will be forced to Timer always if EventMode is set to Off.
			self:SetUpdateFunction(TimerNormalUpdate)
		elseif IsCountDownOn() == true then
			self:SetUpdateFunction(TimerCountDownUpdate)
		else
			self:SetUpdateFunction(TimerNormalUpdate)
		end
	end;
	LoadFont("Common Normal")..{
		Name="timer_text";
		InitCommand=cmd(diffuse,Black());
	};
	LoadActor("_Inf")..{
		Name="timer_infinite_text";
		InitCommand=cmd(y,-1;zoom,0.2);
	};
}

return t